//
// Fragment shader for Image Distortion effect
//
// Author: Shirley Carter
//

uniform sampler2DRect texUnit;
uniform  vec4 modulateColor;

uniform vec4 textureRect;

uniform vec2 drawingOffset;
uniform vec2 drawingScale;
uniform vec4 drawingBoundsRect;
uniform vec4 destRect;
varying vec2 gUV;

bool InBound(float x, float a, float b)
{
    return (x > a && x<=b);
}

bool Vec2InBound(vec2  thisVec, vec4 bounds)
{
    bool ret = InBound(thisVec.x, bounds.x, bounds.x+bounds.z) && InBound(thisVec.y, bounds.y, bounds.y+bounds.w);
    
    return ret;
}
void main(void)
{
   if ( gUV.x< textureRect.x || gUV.x> textureRect.x+textureRect.z || gUV.y < textureRect.y || gUV.y > textureRect.y+textureRect.w )
        gl_FragColor = vec4(0.0,0.0,0.0,0.0);
    else {
        //First transform image coords i, j into x, y from 0 to 1
         float textureWidth = textureRect.z; 
        float textureHeight = textureRect.w;
        vec3 pCoord = gl_FragCoord.xyz;
        // Transform back to render traget coord space
        pCoord /= vec3(drawingScale, 1);
        pCoord += vec3(drawingOffset, 0);
        
        vec2 drawingBoundsOrigin = drawingBoundsRect.xy;
        float drawingBoundsWidth = drawingBoundsRect.z;
        float drawingBoundsHeight = drawingBoundsRect.w;
        
       
        float x = 1.0/drawingBoundsWidth*(pCoord.x-drawingBoundsOrigin.x);
        float y = 1.0/drawingBoundsHeight*(pCoord.y-drawingBoundsOrigin.y);
        
        //////
        //Computer distortion
        float k  = -1.0;//-0.15; //distortion coefficient
        float kcube = .5;//.15; //cubic distortion value
        float scale = .9;
        float dispersion = .01;
        float blurAmount = .5;
        
        float r2 = (x- .5) * (x-.5) + (y - .5) * (y-.5);
        
        //compute cubic distortion, if necessary
        float mult = k;
        if( kcube != 0.0 )
            mult = k + kcube * sqrt( r2 );
        
        float f= 1.0 + r2 * mult;  //factor of distortion
        
        //chromatic aberration variable distortion depending on color
        vec2 tCoord = vec2( x, y ); //x , y coord, not image coord
        vec3 eta = vec3(1.0+dispersion*8.0, 1.0+dispersion*3.0, 1.0+dispersion*1.0);//strong red distortion, weak green and blue
        
        vec2 rCoords = (f*eta.r)*scale*(tCoord.xy-0.5)+0.5;
        vec2 gCoords = (f*eta.g)*scale*(tCoord.xy-0.5)+0.5;
        vec2 bCoords = (f*eta.b)*scale*(tCoord.xy-0.5)+0.5;
      
        if (Vec2InBound(rCoords, textureRect) && Vec2InBound(gCoords, textureRect) && Vec2InBound(bCoords, textureRect)) {
         
            vec2 rCoordsPrime = vec2( rCoords.x*drawingBoundsWidth , rCoords.y*drawingBoundsHeight )+drawingBoundsOrigin;//transform coords back to texture coordinates
            vec2 gCoordsPrime = vec2( gCoords.x*drawingBoundsWidth , gCoords.y*drawingBoundsHeight )+drawingBoundsOrigin;
            vec2 bCoordsPrime = vec2( bCoords.x*drawingBoundsWidth , bCoords.y*drawingBoundsHeight )+drawingBoundsOrigin;
            
            
            rCoordsPrime = gUV+(rCoordsPrime - pCoord.xy)/vec2(drawingBoundsWidth, drawingBoundsHeight)*vec2(textureWidth,textureHeight) ;
            gCoordsPrime = gUV+(gCoordsPrime - pCoord.xy)/vec2(drawingBoundsWidth, drawingBoundsHeight)*vec2(textureWidth,textureHeight) ;
            bCoordsPrime = gUV+(bCoordsPrime - pCoord.xy)/vec2(drawingBoundsWidth, drawingBoundsHeight)*vec2(textureWidth,textureHeight) ;
            
            
            vec3 inputDistort = vec3(0.0);
            
            inputDistort.r = (InBound(rCoordsPrime.x, textureRect.x, textureRect.x+textureWidth) &&  InBound(rCoordsPrime.y, textureRect.y, textureRect.y+textureHeight)) ?texture2DRect(texUnit,rCoordsPrime).r:0.0;//look up color on each channel in texture
            inputDistort.g = (InBound(gCoordsPrime.x, textureRect.x, textureRect.x+textureWidth) &&  InBound(gCoordsPrime.y, textureRect.y, textureRect.y+textureHeight)) ?texture2DRect(texUnit,gCoordsPrime).g:0.0;
            inputDistort.b = (InBound(bCoordsPrime.x, textureRect.x, textureRect.x+textureWidth) &&  InBound(bCoordsPrime.y, textureRect.y, textureRect.y+textureHeight)) ?texture2DRect(texUnit,bCoordsPrime).b:0.0;
            
            
            gl_FragColor = modulateColor*vec4(inputDistort.r,inputDistort.g,inputDistort.b,1.0);//return color
            gl_FragColor.a = texture2DRect(texUnit, gUV).a;
        }
        else
            gl_FragColor = texture2DRect(texUnit, gUV);
       
    }
}

